/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.custinfo;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardTaskBean;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.tasks.custinfo.CustomerContactConstants;
import com.ibm.hsc.iw.tasks.custinfo.CustomerContactInit;
import com.ibm.hsc.iw.tasks.custinfo.CustomerContactState;
import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableCountry;
import com.ibm.hwmca.fw.rcs.conndata.DisplayableSubdivision;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskDefinitionException;
import com.ibm.ui.framework.ValueDescriptor;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SystemBean
extends WizardTaskBean
implements CustomerContactConstants {
    private static final String TRACE_MASKD = "JIWZSYBD";
    private static final String TRACE_MASKF = "JIWZSYBF";
    private static final String TRACE_MASKT = "JIWZSYBT";
    private boolean m_bUseAdminMailingAddress;
    private String m_sStreetAddress;
    private String m_sStreetAddress2;
    private String m_sCityLocality;
    private String m_sCountryRegion;
    private transient ValueDescriptor[] m_vdCountryRegion = new ValueDescriptor[0];
    private String m_sStateProvince;
    private transient ValueDescriptor[] m_vdStateProvince = new ValueDescriptor[0];
    private String m_sPostalCode;
    private String m_sModemNumber;
    private CustomerContactState customerContactState;
    private List availCountries;
    private String countryCode = "";
    private Map availSubdivisions;
    private String subdivisionCode = "";

    public SystemBean(Object object) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->SystemBean()");
        }
        CustomerContactInit customerContactInit = (CustomerContactInit)object;
        this.customerContactState = customerContactInit.getCustomerContactState();
        CustomerInfoData customerInfoData = customerContactInit.getCustomerInfoData();
        this.availCountries = customerContactInit.getAvailableCountries();
        this.availSubdivisions = customerContactInit.getAvailableSubdivisions();
        this.setUseAdminMailingAddress(customerInfoData.isSystemUseAdminAddr());
        this.setStreetAddress(customerInfoData.getSystemStreetAddr());
        this.setStreetAddress2(customerInfoData.getSystemStreetAddr2());
        this.setCityLocality(customerInfoData.getSystemCity());
        if (customerInfoData.getSystemCountryCode().equals("")) {
            this.setCountryCode(customerContactInit.getLocale().getCountry());
        } else {
            this.setCountryCode(customerInfoData.getSystemCountryCode());
        }
        this.setSubdivisionCode(customerInfoData.getSystemSubdivisionCode());
        this.setPostalCode(customerInfoData.getSystemPostalCode());
        this.setModemNumber(customerInfoData.getSystemModemNumber());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--SystemBean()");
        }
    }

    public void setUseAdminMailingAddress(boolean bl) throws IllegalUserDataException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->setUseAdminMailingAddress()");
        }
        this.m_bUseAdminMailingAddress = bl;
        this.updateUTMElements();
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--setUseAdminMailingAddress()");
        }
    }

    public boolean isUseAdminMailingAddress() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->isUseAdminMailingAddress()");
        }
        return this.m_bUseAdminMailingAddress;
    }

    public void setStreetAddress(String string) throws IllegalUserDataException {
        this.m_sStreetAddress = string;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setStreetAddress(" + this.m_sStreetAddress + ")");
        }
    }

    public String getStreetAddress() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getStreetAddress() = " + this.m_sStreetAddress);
        }
        return this.m_sStreetAddress;
    }

    public void setStreetAddress2(String string) throws IllegalUserDataException {
        this.m_sStreetAddress2 = string;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setStreetAddress2(" + this.m_sStreetAddress2 + ")");
        }
    }

    public String getStreetAddress2() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getStreetAddress2() = " + this.m_sStreetAddress2);
        }
        return this.m_sStreetAddress2;
    }

    public void setCityLocality(String string) throws IllegalUserDataException {
        this.m_sCityLocality = string;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setCityLocality(" + this.m_sCityLocality + ")");
        }
    }

    public String getCityLocality() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getCityLocality() = " + this.m_sCityLocality);
        }
        return this.m_sCityLocality;
    }

    public ValueDescriptor[] getCountryRegionList() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getCountryRegionList()");
        }
        return this.m_vdCountryRegion;
    }

    public void setCountryRegion(String string) throws IllegalUserDataException {
        this.m_sCountryRegion = string;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->setCountryRegion(" + this.m_sCountryRegion + ")");
        }
        this.countryCode = this.getCountryCode(string);
        this.subdivisionCode = "";
        this.updateDataBeanInfo(false);
        this.updateUTMElements();
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--setCountryRegion() country code: " + this.countryCode);
        }
    }

    public String getCountryRegion() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getCountryRegion() = " + this.m_sCountryRegion);
        }
        return this.m_sCountryRegion;
    }

    public ValueDescriptor[] getStateProvinceList() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getStateProvinceList()");
        }
        return this.m_vdStateProvince;
    }

    public void setStateProvince(String string) throws IllegalUserDataException {
        this.m_sStateProvince = string;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->setStateProvince(" + this.m_sStateProvince + ")");
        }
        this.subdivisionCode = this.getSubdivisionCode(this.countryCode, string);
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--setStateProvince() subdivision code: " + this.subdivisionCode);
        }
    }

    public String getStateProvince() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getStateProvince() = " + this.m_sStateProvince);
        }
        return this.m_sStateProvince;
    }

    public void setPostalCode(String string) throws IllegalUserDataException {
        this.m_sPostalCode = string;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setPostalCode(" + this.m_sPostalCode + ")");
        }
    }

    public String getPostalCode() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getPostalCode() = " + this.m_sPostalCode);
        }
        return this.m_sPostalCode;
    }

    public void setModemNumber(String string) throws IllegalUserDataException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setModemNumber(" + this.m_sModemNumber + ")");
        }
        this.m_sModemNumber = string;
    }

    public String getModemNumber() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getModemNumber() = " + this.m_sModemNumber);
        }
        return this.m_sModemNumber;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + taskActionEvent.getCurrentElement() + "\n\tElementName   : " + taskActionEvent.getElementName() + "\n\tActionCommand : " + taskActionEvent.getActionCommand());
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
        }
        new AusMicrocodeLog(LOG_INFO1, 1).writeEntryFromTaskletClient();
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--panelAction(...)");
        }
    }

    public Serializable nextButtonHit() throws WizardTaskException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->nextButtonHit()");
        }
        try {
            this.userTaskManager.storeAllElements();
        }
        catch (IllegalUserDataException illegalUserDataException) {
            throw new WizardTaskException(null, null, false);
        }
        if (!this.m_bUseAdminMailingAddress) {
            if (this.getStreetAddress().trim().equals("")) {
                throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.CustomerContactText", "REQUIRED_FIELD_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0505", null));
            }
            if (this.getCityLocality().trim().equals("")) {
                throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.CustomerContactText", "REQUIRED_FIELD_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0506", null));
            }
            if (this.getPostalCode().trim().equals("")) {
                throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.CustomerContactText", "REQUIRED_FIELD_ERROR_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0507", null));
            }
        }
        this.customerContactState.saveSystemState(this);
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--nextButtonHit()");
        }
        return this.customerContactState;
    }

    public Serializable backButtonHit() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->backButtonHit()");
        }
        try {
            block11: {
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, " before setMandatory false calls");
                }
                this.userTaskManager.setMandatory(this.getMountPrefix() + "StreetAddress", false);
                this.userTaskManager.setMandatory(this.getMountPrefix() + "CityLocality1", false);
                this.userTaskManager.setMandatory(this.getMountPrefix() + "PostalCode", false);
                if (3 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, " before storeAllElements");
                }
                try {
                    this.userTaskManager.storeAllElements();
                }
                catch (IllegalUserDataException illegalUserDataException) {
                    if (3 > Trace.LEVEL) break block11;
                    Trace.trace(TRACE_MASKD, " storeAllElements call threw exception");
                }
            }
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, " after storeAllElements");
            }
            this.userTaskManager.setMandatory(this.getMountPrefix() + "StreetAddress", true);
            this.userTaskManager.setMandatory(this.getMountPrefix() + "CityLocality1", true);
            this.userTaskManager.setMandatory(this.getMountPrefix() + "PostalCode", true);
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, " after setMandatory true calls");
            }
        }
        catch (TaskDefinitionException taskDefinitionException) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, " setMandatory call threw exception: " + (Object)((Object)taskDefinitionException));
            }
            new AusMicrocodeLog(LOG_INFO3, 2).writeEntryFromTaskletClient();
        }
        this.customerContactState.saveSystemState(this);
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--backButtonHit()");
        }
        return this.customerContactState;
    }

    public void prepare() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->prepare()");
        }
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--prepare()");
        }
    }

    public void setAvailCountries(List list) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setAvailCountries()");
        }
        this.availCountries = list;
    }

    public void setCountryCode(String string) {
        this.countryCode = string;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setCountryCode(" + this.countryCode + ")");
        }
    }

    public String getCountryCode() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getCountryCode() = " + this.countryCode);
        }
        return this.countryCode;
    }

    public void setAvailSubdivisions(Map map) {
        this.availSubdivisions = map;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setAvailSubdivisions()");
        }
    }

    public void setSubdivisionCode(String string) {
        this.subdivisionCode = string;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->setSubdivisionCode(" + this.subdivisionCode + ")");
        }
    }

    public String getSubdivisionCode() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->getSubdivisionCode() = " + this.subdivisionCode);
        }
        return this.subdivisionCode;
    }

    private void updateDataBeanInfo(boolean bl) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->updateDataBeanInfo(" + bl + ")");
        }
        if (bl) {
            int n = this.availCountries.size();
            if (n > 0) {
                this.m_vdCountryRegion = new ValueDescriptor[n];
                for (int i = 0; i < n; ++i) {
                    String string = ((DisplayableCountry)this.availCountries.get(i)).getDescription();
                    this.m_vdCountryRegion[i] = new ValueDescriptor(null, string);
                }
                if (this.countryCode.equals("")) {
                    DisplayableCountry displayableCountry = (DisplayableCountry)this.availCountries.get(0);
                    this.countryCode = displayableCountry.getIsoCode();
                    this.m_sCountryRegion = displayableCountry.getDescription();
                } else {
                    this.m_sCountryRegion = this.getCountryDesc(this.countryCode);
                }
            } else {
                this.countryCode = "";
                this.m_vdCountryRegion = new ValueDescriptor[0];
                this.m_sCountryRegion = "";
            }
        }
        if (this.availSubdivisions.containsKey(this.countryCode)) {
            List list = (List)this.availSubdivisions.get(this.countryCode);
            int n = list.size();
            this.m_vdStateProvince = new ValueDescriptor[n];
            for (int i = 0; i < n; ++i) {
                String string = ((DisplayableSubdivision)list.get(i)).getDescription();
                this.m_vdStateProvince[i] = new ValueDescriptor(null, string);
            }
            if (this.subdivisionCode.equals("")) {
                DisplayableSubdivision displayableSubdivision = (DisplayableSubdivision)list.get(0);
                this.subdivisionCode = displayableSubdivision.getIsoCode();
                this.m_sStateProvince = displayableSubdivision.getDescription();
            } else {
                this.m_sStateProvince = this.getSubdivisionDesc(this.countryCode, this.subdivisionCode);
            }
        } else {
            this.subdivisionCode = "";
            this.m_vdStateProvince = new ValueDescriptor[0];
            this.m_sStateProvince = "";
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--updateDataBeanInfo()");
        }
    }

    private void updateUTMElements() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->updateUTMElements()");
        }
        if (this.userTaskManager != null) {
            String string = this.getMountPrefix();
            if (this.m_bUseAdminMailingAddress) {
                this.userTaskManager.setEnabled(string + "StreetAddress", false);
                this.userTaskManager.setEnabled(string + "StreetAddress2", false);
                this.userTaskManager.setEnabled(string + "CityLocality1", false);
                this.userTaskManager.setEnabled(string + "CountryRegion", false);
                this.userTaskManager.setEnabled(string + "StateProvince", false);
                this.userTaskManager.setEnabled(string + "PostalCode", false);
            } else {
                this.userTaskManager.setEnabled(string + "StreetAddress", true);
                this.userTaskManager.setEnabled(string + "StreetAddress2", true);
                this.userTaskManager.setEnabled(string + "CityLocality1", true);
                this.userTaskManager.setEnabled(string + "CountryRegion", true);
                if (this.availSubdivisions.containsKey(this.countryCode)) {
                    this.userTaskManager.setEnabled(string + "StateProvince", true);
                } else {
                    this.userTaskManager.setEnabled(string + "StateProvince", false);
                }
                this.userTaskManager.setEnabled(string + "PostalCode", true);
            }
            this.userTaskManager.refreshElement(string + "StreetAddress");
            this.userTaskManager.refreshElement(string + "StreetAddress2");
            this.userTaskManager.refreshElement(string + "CityLocality1");
            this.userTaskManager.refreshElement(string + "CountryRegion");
            this.userTaskManager.refreshElement(string + "StateProvince");
            this.userTaskManager.refreshElement(string + "PostalCode");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--updateUTMElements()");
        }
    }

    private String getCountryCode(String string) {
        String string2 = "";
        Iterator iterator = this.availCountries.iterator();
        while (iterator.hasNext()) {
            DisplayableCountry displayableCountry = (DisplayableCountry)iterator.next();
            if (!displayableCountry.getDescription().equals(string)) continue;
            string2 = displayableCountry.getIsoCode();
            break;
        }
        return string2;
    }

    private String getCountryDesc(String string) {
        String string2 = "";
        Iterator iterator = this.availCountries.iterator();
        while (iterator.hasNext()) {
            DisplayableCountry displayableCountry = (DisplayableCountry)iterator.next();
            if (!displayableCountry.getIsoCode().equals(string)) continue;
            string2 = displayableCountry.getDescription();
            break;
        }
        return string2;
    }

    private String getSubdivisionCode(String string, String string2) {
        String string3 = "";
        if (this.availSubdivisions.containsKey(string)) {
            List list = (List)this.availSubdivisions.get(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DisplayableSubdivision displayableSubdivision = (DisplayableSubdivision)iterator.next();
                if (!displayableSubdivision.getDescription().equals(string2)) continue;
                string3 = displayableSubdivision.getIsoCode();
                break;
            }
        }
        return string3;
    }

    private String getSubdivisionDesc(String string, String string2) {
        String string3 = "";
        if (this.availSubdivisions.containsKey(string)) {
            List list = (List)this.availSubdivisions.get(string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DisplayableSubdivision displayableSubdivision = (DisplayableSubdivision)iterator.next();
                if (!displayableSubdivision.getIsoCode().equals(string2)) continue;
                string3 = displayableSubdivision.getDescription();
                break;
            }
        }
        return string3;
    }
}

